#ifndef __PLUG_PLAY_H
#define __PLUG_PLAY_H

/*******************************************************************************
 * Copyright (c) PLX Technology, Inc.
 *
 * PLX Technology Inc. licenses this source file under the GNU Lesser General Public
 * License (LGPL) version 2.  This source file may be modified or redistributed
 * under the terms of the LGPL and without express permission from PLX Technology.
 *
 * PLX Technology, Inc. provides this software AS IS, WITHOUT ANY WARRANTY,
 * EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, ANY WARRANTY OF
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  PLX makes no guarantee
 * or representations regarding the use of, or the results of the use of,
 * the software and documentation in terms of correctness, accuracy,
 * reliability, currentness, or otherwise; and you rely on the software,
 * documentation and results solely at your own risk.
 *
 * IN NO EVENT SHALL PLX BE LIABLE FOR ANY LOSS OF USE, LOSS OF BUSINESS,
 * LOSS OF PROFITS, INDIRECT, INCIDENTAL, SPECIAL OR CONSEQUENTIAL DAMAGES
 * OF ANY KIND.
 *
 ******************************************************************************/

/******************************************************************************
 *
 * File Name:
 *
 *      PlugPlay.h
 *
 * Description:
 *
 *      Plug 'n' Play handler functions
 *
 * Revision History:
 *
 *      10-01-10 : PLX SDK v6.40
 *
 ******************************************************************************/


#include "PlxTypes.h"



/**********************************************
*               Functions
**********************************************/
// Newer WDKs prefer different declaration for some functions
#if WINVER > 0x0600
    __drv_dispatchType(IRP_MJ_PNP) DRIVER_DISPATCH Dispatch_Pnp; 
#else
    NTSTATUS
    Dispatch_Pnp(
        PDEVICE_OBJECT fdo,
        PIRP           pIrp
        );
#endif

NTSTATUS
PnP_DefaultHandler(
    PDEVICE_OBJECT fdo,
    PIRP           pIrp
    );

NTSTATUS
PnP_QueryRemoveDevice(
    PDEVICE_OBJECT fdo,
    PIRP           pIrp
    );

NTSTATUS
PnP_CancelRemoveDevice(
    PDEVICE_OBJECT fdo,
    PIRP           pIrp
    );

NTSTATUS
PnP_RemoveDevice(
    PDEVICE_OBJECT fdo,
    PIRP           pIrp
    );

NTSTATUS
PnP_StartDevice(
    PDEVICE_OBJECT fdo,
    PIRP           pIrp
    );

NTSTATUS
PnP_StopDevice(
    PDEVICE_OBJECT fdo,
    PIRP           pIrp
    );

NTSTATUS
PnP_QueryDeviceRelations(
    PDEVICE_OBJECT fdo,
    PIRP           pIrp
    );

IO_COMPLETION_ROUTINE PnP_OnRequestComplete;

NTSTATUS
PnP_ForwardAndWait(
    PDEVICE_OBJECT fdo,
    PIRP           pIrp
    );



#endif
